#include "hal_base.h"
#include "hal_gpio.h"
#include "hal_adc.h"
#include "hal_irq.h"


uint16_t adc_value = 0;	//ADCתֵ


/* GPIOʼʹPB1 AIN5ͨPB2Ϊ߻ͣ
   PB1PB5̽ӣAINPB5ѹ */
void GPIO_init(void)
{
	gpio_init_t init;
	init.io = GPIO_INPUT;
	init.level = GPIO_LOW_LEVEL;
	init.mode = GPIO_ANALOG_MODE;
	init.pu = DISABLE;
	init.pd = DISABLE;
	init.drive = GPIO_LOW_DRIVER;
	init.od = DISABLE;
	init.smit = GPIO_1_5_TO_3_0_SMIT;
	init.cur_ctr = DISABLE;
	gpio_init(PB_TYPE, GPIO_PIN_1, &init);

	init.io = GPIO_OUTPUT;
	init.mode = GPIO_DIGIT_MODE;
	gpio_init(PB_TYPE, GPIO_PIN_2, &init);
	gpio_write_pin(PB_TYPE, GPIO_PIN_2, 1);
}

/* жϷжΪADCжжϱ־ȡADCתֵ */
void isr(void) interrupt
{
	if (irq_get_it_status(ADIE_IT) && irq_get_flag_status(ADIE_IT)) {
		irq_clear_flag_status(ADIE_IT);
		adc_value = adc_get_value();
	}
}

void main() 
{
	// adc ʼṹ
	adc_init_t ad_init;

	// RAMʼ
	ram_clear();
	// clockʼѡHRC,Ƶʹclock
	clock_init(CLOCK_SRC_HRC, CLOCK_DIV_1, DISABLE);
	// GPIOʼ
	GPIO_init();

	// ʼADC
	ad_init.speed = ADC_LOW_SPEED;
	ad_init.samp_clk = ADC_TADCLK_8;
	ad_init.clk_div = ADC_CLKDIV_1;
	ad_init.align = ADC_DATAALIGN_LOW;
	ad_init.start_mode = ADC_HARD_START;
	ad_init.channel = ADC_CHANNEL_5;
	adc_init(&ad_init);

	//ж
	IRQ_GIE_CFG(1);
	//ʹADCж
	irq_config(ADIE_IT, ENABLE);
	//ADCת
	ADC_START();

	while (1) {
		// ι
		CLRWDT();
		// ADCת
		ADC_START();
	}
}